implementation module StdPSt

//	Clean Standard Object I/O library, version 1.1

import	StdBool, StdFile, StdFileSelect, StdFunc, StdTuple
/* RWS ---
from	pointer			import LoadLong
from	fonts			import RealFont
from	OS_utilities	import SysBeep,Secs2Date,Secs2Time
from	quickdraw		import QObscureCursor
import	commondef, windowcursor, processdefaccess, StdFont, StdIOCommon
from	font			import defaultfont, dialogfont, selectfont, fontnames, fontstyles, fontsizes, FontAttsToFont, FontAtts
from	iostate			import PSt, IOSt, 
									accIOToolbox, appIOToolbox, getIOToolbox, setIOToolbox, 
									IOStGetWorld, IOStSetWorld, 
									IOStGetProcessAttributes, IOStSetProcessAttributes, 
									IOStSetDoubleDownDist, DoubleDownDist,
									IOStGetDocumentInterface
from	windowaccess	import IOStGetDialogCursorInfo, IOStSetDialogCursorInfo
*/
// RWS +++
import iostate, commondef, processdefaccess, channelenv
import StdId, StdIOCommon, StdTime
import osbeep, osfileselect
// PA+++
import ospicture
import clCrossCall,scheduler
// MW+++
import StdReceiver, receiverid, receiverhandle, receiverdevice

/*	PSt is an environment instance of the class FileEnv (see StdFile).
*/
instance FileEnv (PSt .l .p) where
	accFiles :: !.(*Files -> (.x,*Files)) !*(PSt .l .p) -> (!.x,!*PSt .l .p)
	accFiles accfun pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (x,world)			= accFiles accfun world
		  pState			= {pState & io=IOStSetWorld world io}
		= (x,pState)
	
	appFiles :: !.(*Files -> *Files) !*(PSt .l .p) -> *PSt .l .p
	appFiles appfun pState=:{io}
		# (world,io)		= IOStGetWorld io
		  world				= appFiles appfun world
		  pState			= {pState & io=IOStSetWorld world io}
		= pState

instance FileEnv	(IOSt .l .p)
  where
	accFiles accfun io
		# (world,io)		= IOStGetWorld io
		  (x,world)			= accFiles accfun world
		  io				=IOStSetWorld world io
		= (x,io)
	appFiles appfun io
		# (world,io)		= IOStGetWorld io
		  world				= appFiles appfun world
		  io				= IOStSetWorld world io
		= io

/*	PSt is an environment instance of the class FileSelectEnv (see StdFileSelect).
*/
instance FileSelectEnv (PSt .l .p) where
	selectInputFile :: !(PSt .l .p) -> (!Maybe String,!PSt .l .p)
	selectInputFile pState
		# (ok,name,pState,_)	= OSselectinputfile handleOSEvent pState OSNewToolbox
		= (if ok (Just name) Nothing,pState)
	
	selectOutputFile:: !String !String !(PSt .l .p) -> (!Maybe String,!PSt .l .p)
	selectOutputFile prompt originalName pState
		# (ok,name,pState,_)	= OSselectoutputfile handleOSEvent pState prompt originalName OSNewToolbox
		= (if ok (Just name) Nothing,pState)

//	handleOSEvent turns handleOneEventForDevices into the form required by OSselect(in/out)putfile.
handleOSEvent :: !OSEvent !(PSt .l .p) -> PSt .l .p
handleOSEvent osEvent pState
	= thd3 (handleOneEventForDevices (ScheduleOSEvent osEvent []) pState)


/*	PSt is an environment instance of the class TimeEnv (see StdTime).
*/
instance TimeEnv (PSt .l .p) where
	getBlinkInterval :: !(PSt .l .p) -> (!Int,!PSt .l .p)
	getBlinkInterval pState
		= accPIO getBlinkInterval pState
	
	getCurrentTime :: !(PSt .l .p) -> (!Time,!PSt .l .p)
	getCurrentTime pState
		= accPIO getCurrentTime pState
	
	getCurrentDate :: !(PSt .l .p) -> (!Date,!PSt .l .p)
	getCurrentDate pState
		= accPIO getCurrentDate pState

	getCurrentTick :: !(PSt .l .p) -> (!Tick,!PSt .l .p)
	getCurrentTick pState
		= accPIO getCurrentTick pState

instance TimeEnv (IOSt .l .p) where
	getBlinkInterval :: !(IOSt .l .p) -> (!Int,!IOSt .l .p)
	getBlinkInterval io
		# (world,io)		= IOStGetWorld io
		  (blink,world)		= getBlinkInterval world
		= (blink,IOStSetWorld world io)
	
	getCurrentTime :: !(IOSt .l .p) -> (!Time,!IOSt .l .p)
	getCurrentTime io
		# (world,io)		= IOStGetWorld io
		  (time,world)		= getCurrentTime world
		= (time,IOStSetWorld world io)
	
	getCurrentDate :: !(IOSt .l .p) -> (!Date,!IOSt .l .p)
	getCurrentDate io
		# (world,io)		= IOStGetWorld io
		  (date,world)		= getCurrentDate world
		= (date, IOStSetWorld world io)

	getCurrentTick :: !(IOSt .l .p) -> (!Tick,!IOSt .l .p)
	getCurrentTick io
		# (world,io)		= IOStGetWorld io
		  (tick,world)		= getCurrentTick world
		= (tick, IOStSetWorld world io)

/*	PSt is an environment instance of the class ChannelEnv (see channelenv).						*/

instance ChannelEnv (PSt .l .p)
  where
	channelEnvKind env
		= (PST, env)
	mb_close_inet_receiver_without_id reallyDoIt id_pair pSt=:{io}
		= { pSt & io = mb_close_inet_receiver_without_id True id_pair io }

instance Ids (PSt .l .p)
  where
	openId pSt
		= doWithIO openId pSt
	openIds	i pSt=:{io}
		= doWithIO (openIds i) pSt
	openRId	pSt
		= doWithIO openRId pSt
	openRIds i pSt
		= doWithIO (openRIds i) pSt
	openR2Id pSt
		= doWithIO openR2Id pSt
	openR2Ids i pSt
		= doWithIO (openR2Ids i) pSt

doWithIO f pSt=:{io}
	# (x, io)	= f io
	= (x, { pSt & io=io } )
	
/*	IOSt is also an environment instance of the class ChannelEnv	*/

instance ChannelEnv (IOSt .l .p)
  where
	channelEnvKind env
		= (IOST, env)
	mb_close_inet_receiver_without_id False _ ioState
		= ioState
	mb_close_inet_receiver_without_id True id_pair ioState
		# (receivers,ioState)	= IOStGetDevice ReceiverDevice ioState
		  rsHs					= (ReceiverSystemStateGetReceiverHandles receivers).rReceivers
		  (found,rsH,rsHs)		= Remove (inetReceiverStateIdentified1 id_pair) undef rsHs
		# ioState				= IOStSetDevice (ReceiverSystemState {rReceivers=rsHs}) ioState
		| not found
			= ioState
		# ioState				= unbindRId rsH.rHandle.rId ioState
		  closeAlsoIds			= rsH.rHandle.rConnected
		  ioState				= seq (map closeReceiver closeAlsoIds) ioState
		  (_,_,_,closeFun)		= fromJust rsH.rHandle.rInetInfo
		  ioState				= appIOToolbox closeFun ioState
		  ioState				= IOStSetRcvDisabled True ioState
		= ioState

inetReceiverStateIdentified1 :: !(!EndpointRef`, !InetReceiverCategory`) !(ReceiverStateHandle .ps) -> Bool
inetReceiverStateIdentified1 x {rHandle} = inetReceiverIdentified x rHandle

/*	accScreenPicture provides access to an initial Picture as it would be created in
	a window or control.
*/
class accScreenPicture env :: !(St *Picture .x) !*env -> (!.x,!*env)

instance accScreenPicture World where
	accScreenPicture :: !(St *Picture .x) !*World -> (!.x,!*World)
	accScreenPicture fun world
		# (tb,world)	= WorldGetToolbox world
		# (x,tb)		= peekScreen fun tb
		# world			= WorldSetToolbox tb world
		= (x,world)
instance accScreenPicture (IOSt .l .p) where
	accScreenPicture :: !(St *Picture .x) !(IOSt .l .p) -> (!.x,!IOSt .l .p)
	accScreenPicture fun ioState
		= accIOToolbox (peekScreen fun) ioState


/*	Emit the alert sound.
*/
beep :: !(IOSt .l .p) -> IOSt .l .p
beep ioState = appIOToolbox OSBeep ioState

/* RWS ---
/*	Set the shape of the cursor globally. This shape overrules the local cursor shapes of windows.
*/
setCursor :: !CursorShape !(IOSt .l .p) -> IOSt .l .p
setCursor shape ioState
#	(cInfo,ioState)	= IOStGetDialogCursorInfo ioState
	(cInfo,ioState)	= accIOToolbox (cursorinfoSetGlobalCursor shape cInfo) ioState
	ioState			= IOStSetDialogCursorInfo cInfo ioState
=	ioState


/*	resetCursor undoes the effect of SetCursor.
*/
resetCursor :: !(IOSt .l .p) -> IOSt .l .p
resetCursor ioState
#	(cInfo,ioState)	= IOStGetDialogCursorInfo ioState
	(cInfo,ioState)	= accIOToolbox (cursorinfoResetGlobalCursor cInfo) ioState
	ioState			= IOStSetDialogCursorInfo cInfo ioState
=	ioState


/*	obscureCursor hides the cursor until the mouse is moved.
*/
obscureCursor :: !(IOSt .l .p) -> IOSt .l .p
obscureCursor ioState = appIOToolbox QObscureCursor ioState


/*	setDoubleDownDistance sets the double down distance of the mouse. Negative values are set to zero.
*/
setDoubleDownDistance :: !Int !(IOSt .l .p) -> IOSt .l .p
setDoubleDownDistance newDDDist ioState = IOStSetDoubleDownDist newDDDist ioState

--- RWS */

/*	getDocumentInterface retrieves the DocumentInterface of an interactive process.
*/
getDocumentInterface :: !(IOSt .l .p) -> (!DocumentInterface, !IOSt .l .p)
getDocumentInterface ioState = IOStGetDocumentInterface ioState


/*	Operations on the attributes of an interactive process:
*/
setProcessActivate :: !(IdFun (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
setProcessActivate activateF ioState
	# (pAtts,ioState)	= IOStGetProcessAttributes ioState
	= IOStSetProcessAttributes (setProcessAttribute isprocessactivate (ProcessActivate activateF) pAtts) ioState

setProcessDeactivate :: !(IdFun (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
setProcessDeactivate deactivateF ioState
	# (pAtts,ioState)	= IOStGetProcessAttributes ioState
	= IOStSetProcessAttributes (setProcessAttribute isprocessdeactivate (ProcessDeactivate deactivateF) pAtts) ioState

setProcessHelp :: !(IdFun (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
setProcessHelp helpF ioState
	# (pAtts,ioState)	= IOStGetProcessAttributes ioState
	= IOStSetProcessAttributes (setProcessAttribute isprocesshelp (ProcessHelp helpF) pAtts) ioState

setProcessAbout :: !(IdFun (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
setProcessAbout aboutF ioState
	# (pAtts,ioState)	= IOStGetProcessAttributes ioState
	= IOStSetProcessAttributes (setProcessAttribute isprocessabout (ProcessAbout aboutF) pAtts) ioState

setProcessAttribute :: !(Cond (ProcessAttribute .ps)) !(ProcessAttribute .ps) ![ProcessAttribute .ps] -> [ProcessAttribute .ps]
setProcessAttribute cond pAtt` [pAtt:pAtts]
	| cond pAtt
		= [pAtt`:pAtts]
		= [pAtt :setProcessAttribute cond pAtt` pAtts]
setProcessAttribute _ pAtt` _
		= [pAtt`]


//	Coercing PSt component operations to PSt operations.

appListPIO :: ![.IdFun (IOSt .l .p)] !(PSt .l .p) -> PSt .l .p
appListPIO fs pState=:{io} = {pState & io=StrictSeq fs io}

appListPLoc :: ![.IdFun .l] !(PSt .l .p) -> PSt .l .p
appListPLoc fs pState=:{ls} = {pState & ls=StrictSeq fs ls}

appListPPub :: ![.IdFun .p] !(PSt .l .p) -> PSt .l .p
appListPPub fs pState=:{ps} = {pState & ps=StrictSeq fs ps}

appPIO :: !.(IdFun (IOSt .l .p)) !(PSt .l .p) -> PSt .l .p
appPIO f pState=:{io} = {pState & io=f io}

appPLoc :: !.(IdFun .l) !(PSt .l .p) -> PSt .l .p
appPLoc f pState=:{ls} = {pState & ls=f ls}

appPPub :: !.(IdFun .p) !(PSt .l .p) -> PSt .l .p
appPPub f pState=:{ps} = {pState & ps=f ps}


//	Accessing PSt component operations.

accListPIO :: ![.St (IOSt .l .p) .x] !(PSt .l .p) -> (![.x],!PSt .l .p)
accListPIO fs pState=:{io}
	# (xs,io) = StrictSeqList fs io
	= (xs,{pState & io=io})

accListPLoc :: ![.St .l .x] !(PSt .l .p) -> (![.x],!PSt .l .p)
accListPLoc fs pState=:{ls}
	# (xs,ls) = StrictSeqList fs ls
	= (xs,{pState & ls=ls})

accListPPub :: ![.St .p .x] !(PSt .l .p) -> (![.x],!PSt .l .p)
accListPPub fs pState=:{ps}
	# (xs,ps) = StrictSeqList fs ps
	= (xs,{pState & ps=ps})

accPIO :: !.(St (IOSt .l .p) .x) !(PSt .l .p) -> (!.x,!PSt .l .p)
accPIO f pState=:{io}
	# (x,io) = f io
	= (x,{pState & io=io})

accPLoc :: !.(St .l .x) !(PSt .l .p) -> (!.x,!PSt .l .p)
accPLoc f pState=:{ls}
	# (x,ls) = f ls
	= (x,{pState & ls=ls})

accPPub :: !.(St .p .x) !(PSt .l .p) -> (!.x,!PSt .l .p)
accPPub f pState=:{ps}
	# (x,ps) = f ps
	= (x,{pState & ps=ps})


